#ifndef __SDK_DEF_H__
#define __SDK_DEF_H__
#include "sdk_error.h"

#if defined(WIN32)
#if defined(SDKS_BUILD_DLL)
#define SDKS_API extern "C" __declspec(dllexport)
#elif defined(SDKS_USE_DLL)
#define SDKS_API extern "C"  __declspec(dllimport)
#else
#define SDKS_API
#endif
#else
#ifdef __cplusplus
#define SDKS_API extern "C"
#else
#define SDKS_API extern
#endif
#endif

typedef void(*SDK_NVR_SNAP_MSG_CB)(unsigned int handle, void* p_data, void* p_obj);
typedef void(*SDK_WIFI_CB)(unsigned int handle, char* p_data, void* p_obj);
typedef void(*SDK_ALARM_CB)(unsigned int handle, void** p_data, void* p_obj);
typedef void(*SDK_STREAM_CB)(unsigned int handle, int stream_id, void* p_data, void* p_obj);
typedef void(*SDK_STREAM_THERMAL_PIC_CB)(unsigned int handle, int stream_id, void** p_result, void* p_data, void* p_obj);
typedef void(*SDK_DISCONN_CB)(unsigned int handle, void* p_obj,int type);
typedef void(*SDK_CONNECT_CB)(unsigned int handle, void* p_obj);
typedef void(*SDK_PLAY_TIME_CB)(unsigned int handle, int stream_id, void* p_obj, const char* p_time);
typedef void(*SDK_STREAM_DATE_LEN)(unsigned long len);
typedef void(*SDK_DETECT_CB)(unsigned int handle, int stream_id, void** p_result, void* p_data, void* p_obj);
typedef void(*SDK_FACE_CB)(unsigned int handle, int pic_type,void* p_data, int *data_len, void** p_result, void* p_obj);//pic_type: 1 base library, 2 real-time library
typedef void(*SDK_MUTI_OBJ_DOWNLOAD_CB)(unsigned int handle, void* p_pic1, int data_len1,char *key1 ,void* p_pic2, int data_len2, char *key2, void* p_obj);//pic_type: 1 base library, 2 real-time library
typedef void(*SDK_NVR_COMPARE_CB)(unsigned int handle, void* p_pic1, int data_len1, void* p_pic2, int data_len2, void* p_result, void* p_obj);

typedef void(*SDK_MICROPHONE_CB)(unsigned int handle, void* p_data, int *data_len, void* p_obj);
typedef void(*SDK_INTERCOM_DB_CB)(unsigned int db, void*p_obj);
typedef void(*SDK_S3_PB_PLAY)(unsigned int handle, int stream_id, void* p_obj, void* p_data, unsigned int type);

#define MAX_DEV_NAME_LEN  128
#define MAX_IP_BUF_LEN  128
#define CONST_MAX_ALARM_IO_NUM  10					//max number of IO alarm
#define CONST_MAX_PERIOD_RECORD_TIME_NUM  16				//allowed max number of time periods for recording
#define CONST_MAX_ALARM_OUT_NUM   16						//allowed max number of channels for alarm output	
#define MAX_LENGTH_DEVICEID   32		//length of device id
typedef enum  video_stream_type_e
{
	STREAM_TYPE_1 = 1,                     // HD
	STREAM_TYPE_2,                         // Smooth
	STREAM_TYPE_3
}video_stream_type_e;

enum Device_Type     //device type
{
	IPCAMERA = 1,	//IP camera
	DVR = 2,	//Digital Video Recorder
	DVS = 3,	//Digital Video Server
	IPDOME = 4,	//IP speed dome
	NVR = 5,	//NVR
	ONVIF_DEVICE = 6,	//Onvif device
	DECODER = 7,	//decoder
	LPR = 8,	//License Plate Recognition camera
	FISHEYE = 9,    //fisheye camera
	NVR_2 = 10,   //NVR marked 4.0
	IPP = 11,   //IP Panoramic camera
	THERMAL_DEVICE = 13,	//thermal camera
	HUMAN_TEMPERATURE = 14,//human body temperature measurement camera
	FACE_DETECT = 15,//face detection camera
	VEHICLE_DETECT = 16,//domestic license plate - Zhixin
	THERMAL_DOUBLE_SENSOR_DEVICE = 17,	//bi-spectrum thermal camera
	AIMULTI_OBJECT_DETECT = 18,//AI MULTI OBJECT DETECT
	THERMAL_DOUBLE_SENSOR_DOME_DEVICE = 19,	//bi-spectrum thermal camera(visible lens connect the movement))
	DOMECORE_THERMAL_DEVICE = 20,			//Zhongan PTZ dual IP connected to pmd1030 movement
	FACE_DEVICE = 21,  //face detection smart box
	HK_DVR = 100,	//HK DVR
	RS_DVR = 101,	//RaySharp DVR
	DH_DVR = 102,	//Dahua DVR
	VIRTUAL_NVR = 103,   //compatible with the local server used by the NVR client
	DOMECORE = 104	//movement
};


typedef struct FRAME_INFO {
	long nWidth;	// width of the screen, in pixels, it will be 0 if it is audio data
	long nHeight;	// height of the screen, in pixels, it will be 0 if it is audio data
	long nStamp;	// time stamp information, in milliseconds
	long nType;		//data type, see table below
	long nFrameRate;// the frame rate of the image generated during encoding
}FRAME_INFO;

typedef struct tagAVFrameData
{
	long					nStreamFormat;						//1 represents the original stream, 2 represents the TS hybrid stream, 3 represents the original encrypted stream, and 4 represents the PS hybrid stream
	long					nESStreamType;						//type of raw stream, 1 for video, 2 for audio
	long					nEncoderType;						//encoding format
	long					nCameraNo;							//camera number, indicating which channel the data comes from
	unsigned long			nSequenceId;						//sequence number of the data frame
	long					nFrameType;							//data frame type, 1 means I frame, 2 means P frame, 0 means unknown type
	long long				nAbsoluteTimeStamp;					//data collection timestamp, in microseconds
	long long				nRelativeTimeStamp;					//data collection timestamp, in microseconds
	char*					pszData;							//data
	unsigned long			nDataLength;						//valid length of data
	long					nFrameRate;							//frame rate
	long					nBitRate;							//current bit rate
	long					nImageFormatId;						//current format
	long					nImageWidth;						//width of video
	long					nImageHeight;						//height of video
	long					nVideoSystem;						//current video format
	unsigned long			nFrameBufLen;						//current buffer length

	long					nStreamId;							// stream ID
	long					nTimezone;							// time zone
	long					nDaylightSavingTime;				// DST
}ST_AVFrameData;

typedef struct tagTargeHead
{
	int					targe_id;				//target Id
	unsigned short		type;					//type: face, human body, license plate, vehicle, etc.
	unsigned short		x;						//the abscissa of the starting point
	unsigned short		y;						//vertical coordinates of the starting point
	unsigned short		w;						//rectangle width
	unsigned short		h;						//rectangle height
	unsigned short		attr_data_len;			//length of attribute data length

}tagTargeHead;

typedef struct tagPersonFace
{
	//tagTargeHead		headInfo;
	unsigned short		confidence;				//confidence
	unsigned short		yaw;					//yaw angle
	unsigned short		tilt;					//tilt angle
	unsigned short		pitch;					//pitch angle
	unsigned short		gender;					//gender
	unsigned short		age;					//age
	unsigned short		complexion;				//complexion
	unsigned short		minority;				//minority
	float				temperature;			//face temperature
	unsigned short      temperature_unit;       //unit of face temperature
	char				reserve[30];			//reserved field
	unsigned int		land_mark_size;			//number of feature points
	//char*		        land_mark_data;			//Feature point data
}tagPersonFace;

typedef struct _upbody_info_s
{
	//tagTargeHead		headInfo;
	unsigned short		confidence;
	unsigned short		gender;//sex ,[0-100],100--woman
	unsigned short		age;
	unsigned short		complexion;
	unsigned char		backpack;
	unsigned char		human_move;
	unsigned char		move_direction;
	unsigned char		ride_bike;
	unsigned char		ride_motorbike;
	unsigned char		human_face_visible;
	unsigned char		human_facing;
	unsigned char		human_facing_confidence;
}upbody_info_s;

typedef struct _plate_info_s
{
	//tagTargeHead		headInfo;
	unsigned short		have_plate;//whether there is a license plate, 0 no, 1 yes
	unsigned short		plate_angleH;//! angle
	unsigned short		plate_angleV;//! angle
	unsigned short		plate_color;	//! <color of license plate
	unsigned short		plate_type;	//! <type of license plate
	unsigned short		plate_confidence; //! <confidence of license plate
	unsigned short		plate_country;//! < license plate from which country
	unsigned short		char_num;		//! <number of license plate characters
	char plate_num[32];		//! <plate number
	char plate_char_confidence[32];//! <confidence for each character of the plate number
}plate_info_s;

typedef struct _vehicle_info_s
{
	//tagTargeHead		headInfo;
	unsigned short		have_plate;//whether there is a license plate, 0 no, 1 yes
	unsigned short		vehicle_plate_angleH;	//!<  horizontal tilt angle of license plate;
	unsigned short		vehicle_plate_angleV;	//!<  vertical tilt angle of the license plate;
	unsigned short		vehicle_color;	//!<  color of vehicle;
	unsigned short		vehicle_type; //!<  type of vehicle, motor vehicle, non-motor vehicle;
	unsigned short		confidence;
	unsigned short		vehicle_model; //!<  vehicle model, large vehicle, small vehicle
	unsigned short		vehicle_speed;	//!<  vehicle speed;
	unsigned short		Vehicle_moving;	//!< whether the vehicle is in movement
	unsigned short		char_num;		//! <number of license plate characters
	char				plate_num[32];		//! <plate number
	char				plate_char_confidence[32];//! <confidence for each character of the plate number
	unsigned short		Move_direction;//!< vehicle moving direction
	unsigned short		Move_direction_confidence;//!< reliability of vehicle movement direction
	unsigned short		Vehicle_facing;//!< vehicle direction
	unsigned short		Vehicle_facing_confidence;//!< confidence of vehicle direction
	char				trademark_utf8[32];//!< vehicle brand
	unsigned short		trademark_utf8_confidence;//!< confidence of vehicle brand
	unsigned short		Reserve;
}vehicle_info_s;

typedef struct tagDetectFaceData
{
	char				magic[4];				//magic number, default 0xffff ffff
	int					vesion;					//payload protocol version number, in network byte order
	unsigned int		total_len;				//entire structure length, in network byte order
	unsigned int		picture_len;			//image data length, in network byte order
	unsigned short		full_image_width;		//the width of the large image, Full_corp=0 is valid, in network byte order
	unsigned short		full_image_hight;		//the height of the big picture, Full_corp=0 is valid, in network byte order												
	//long long			capture_time;           //detect the target time, in seconds, in network byte order
	unsigned int capture_timeh;
	unsigned int capture_timel;
	unsigned int		sequence_id;			//sequence ID, order of network bytes
	char				full_crop;				//big picture and small picture 0 (large) 1 (small)
	char				reserve[31];			//reserved field
	unsigned int		target_size;			//detect the number of targets, in network byte order
}ST_DetectFaceData;
//raw data of thermal camera
typedef struct tagThermalAVData
{
	char				magic[4];				//magic number, default 0xffff ffff
	unsigned int		vesion;					//payload protocol version number, in network byte order
	unsigned int		head_len;				//length of header data, in network byte order
	unsigned int		payload_len;			//length of the original data, in network byte order
	unsigned int		image_width;			//width of the raw image, in network byte order
	unsigned int		image_hight;			//height of the raw image, in network byte order
	unsigned int		image_stride;			//the span of the raw image (in bytes, imageStride/imageWidth=the number of bytes occupied by each pixel, the current raw image is valid for high 14bit), in network byte order
	unsigned int		mirror_mode;			//mirror mode of raw images (:normal, :horizontal, :vertical, :horizontal-vertical), in network byte order
	unsigned int		capture_timeh;          //high-order timestamp of raw image, in network byte order
	unsigned int		capture_timel;          //low-order timestamp of raw image, in network byte order
	unsigned int		sequence_id;			//sequence ID, in network byte order
	char				reserve[64];			//reserved field
}ST_ThermalAVData;


// hardware capacity
typedef struct _dev_hw_cap_t_
{
	unsigned short				chn_num;	              //number of channels (number of cameras)
	unsigned char				audio_in_num;	          //number of audio inputs
	unsigned char				sound_type;	              //type of audio channel
	unsigned char				audio_out_num;	          //number of audio outputs
	unsigned char				alarm_in_num;	          //number of alarm inputs
	unsigned char				alarm_out_num;	          //number of alarm outputs
	unsigned char				rs485_num;	              //number of RS485 serial ports
	unsigned char				rs232_Num;	              //number of RS232 serial ports
	unsigned char				netcard_num;	          //number of wired network cards
	unsigned char				usb_num;	              //number of USB
	unsigned char				sd_num;	                  //number of SD card
	unsigned char				hd_num;	                  //number of hard disks
	unsigned char				is_wifi;	              //whether to support wifi
	unsigned char				is_poe;	                  //whether to support POE
	unsigned char				is_ir;	                  //whether to support infrared
	unsigned char				is_pir;	                  //whether to support PIR
	unsigned char				is_bnc;	                  //whether to support analog channels
	unsigned char				is_ptz;	                  //whether to support built-in PTZ
	unsigned char				is_face;	                //whether to support face database
	unsigned short              virtualPTZ_Type;            //types of Virtual PTZs
	unsigned short              aiDetec_Type;             //type of AI detection and capture, face/license plate/human shape/face recognition, can change a variety of types, solve all kinds of matching problems, can be configured in hardware
	unsigned char				is_faceDetect;	           //whether to support face detection
	unsigned char               resv;                      //reserved field
}dev_hw_cap_t;

// software capacity
typedef struct _dev_sw_cap_t_
{
	unsigned char				max_user_num;	    //Max number of logged in users
	unsigned char				max_preview_num;	//Max real-time preview channels
	unsigned char				max_pb_num;	        //Max playback and download channels
	unsigned char               resv;               //reserved field
}dev_sw_cap_t;

// audio capacity
typedef struct _dev_audio_cap_t_
{
	unsigned char               is_interphone;       //two-way audio
	unsigned char               is_audio_in;         //audio input
	unsigned char               is_audio_out;        //audio output
	unsigned char               resv;                //reserved field
}dev_audio_cap_t;

typedef struct _dev_sensor_check_t_
{
	int		channel_id;
	int		n_param;
}dev_sensor_check_t;

// device overview
typedef struct _dev_general_info_t_
{
	char	 dev_id[MAX_DEV_NAME_LEN];	                  //device id
	char	 dev_name[MAX_DEV_NAME_LEN];				  //device name
	char     dev_style[MAX_LENGTH_DEVICEID];			  //device type
	char	 dev_ip[MAX_IP_BUF_LEN];					  //device IP
	char	 dev_mac[MAX_IP_BUF_LEN];					  //MAC address
	char	 dev_man_name[MAX_DEV_NAME_LEN];              //manufacturer name
	char	 dev_man_id[MAX_DEV_NAME_LEN];                //device model
	char	 prod_model[MAX_DEV_NAME_LEN];	              //product module
	char     dev_sn[MAX_DEV_NAME_LEN];	                  //SN
	char     sw_info[MAX_DEV_NAME_LEN];	                  //software information
	char     hw_info[MAX_DEV_NAME_LEN];	                  //hardware information
	short    dev_type;                                   //device type
	unsigned short dev_port;                          //device ports
}dev_general_info_t;

// device name
typedef struct _dev_name_t_
{
	char dev_name[MAX_DEV_NAME_LEN];				  //device name
}dev_name_t;

// device time
typedef struct _dev_time_t_
{
	unsigned short         year;                     //year
	unsigned char          mon;                      //month
	unsigned char          day;                      //day
	unsigned char          hour;                     //hour
	unsigned char          min;                      //min
	unsigned char          sec;                      //sec
	unsigned char          resv;                     //reserve
}dev_time_t;

// ntp parameters
typedef struct _ntp_param_t_
{
	char             serv_ip[MAX_IP_BUF_LEN];              //server ip
	unsigned short   serv_port;                            //server port
	unsigned char    is_enable;                            //whether to enable ntp
	unsigned char    ip_proto_ver;                         //version of IP protocol
	unsigned int     ntp_time;                             //ntp time
}ntp_param_t;

typedef struct _dev_port_t_
{
	char                        dev_id[MAX_DEV_NAME_LEN];             //device id
	unsigned short				ctrl_port;	                          //device network control port for network video devices
	unsigned short				av_port;	                          //TCP audio and video ports for network video equipment
	unsigned short				http_port;	                          //HTTP port of the network video device
	unsigned short				https_port;	                          //HTTPS port of the network video device
	unsigned short				rtsp_port;	                          //RTSP port for network video devices
    unsigned short              ssl_port;
}dev_port_t;

// PTZ operation
typedef enum ptz_operation_e
{
	PTZ_STOP = 0,  //stop	
	PTZ_UP = 1,        //up
	PTZ_DOWN = 2,      //down	
	PTZ_LEFT = 3,      //left
	PTZ_RIGHT = 4,     //right	
	PTZ_LEFT_UP = 5,   //left up	
	PTZ_LEFT_DOWN = 6, //left down
	PTZ_RIGHT_UP = 7,  //righ up
	PTZ_RIGHT_DOWN = 8, //right down
	PTZ_ZOOM_IN = 9,     //zoom in
	PTZ_ZOOM_OUT = 10,   //zoom out
	PTZ_FOCUS_FAR = 11,  //focus far
	PTZ_FOCUS_NEAR = 12,  //focus near
	PTZ_IRIS_INC = 13,   //iris increase
	PTZ_IRIS_DEC = 14,   //iris decresse
	PTZ_PRESET_SET = 15, //preset set
	PTZ_PRESET_CALL = 16, //preset call
	PTZ_PRESET_DEL = 17,  //preset delete
	//PTZ_TRACE_SET= 18,   //trace set
	//PTZ_TRACE_CALL= 19,  //trace call
	//PTZ_TRACE_DEL= 20,   //trace delete
	PTZ_SCAN_CALL=21,    //scan call
	PTZ_SCAN_SET_START = 22,  //set the starting point of the scan
	PTZ_SCAN_SET_STOP = 23,  //set the end point of the scan
	PTZ_AUTO_FOCUS = 24,     //auto focu
	PTZ_AUTO_IRIS = 25,     //auto iris
	PTZ_START_AUTO_STUDY = 26, //start auto study
	PTZ_END_AUTO_STUDY = 27,  //end auto study
	PTZ_RUN_AUTO_STUDY = 28,  //run auto study
	PTZ_RESET = 29,           //reset
	PTZ_3D_ORIENTATION = 30,  //3D orientation
	PTZ_TOUR_SET_START = 31,   //set tour start point
	PTZ_TOUR_ADD_PRESET = 32,  //add tour preset point
	PTZ_TOUR_SET_END = 33,    //set end point of tour
	PTZ_TOUR_RUN = 34,        //tour call
	PTZ_TOUR_PAUSE = 35,       //pause tour
	PTZ_TOUR_DEL = 36,        //delete tour
	PTZ_TOUR_CONTINUE = 200,   //continue tour (used in conjunction with pause tour)
	PTZ_KEEPER_SET = 37,      //keeper set
	PTZ_KEEPER_RUN = 38,      //run keeper
	PTZ_RUN_BRUSH = 39,      //run brush
	PTZ_OPEN_LIGHT = 40,       //light on
	PTZ_CLOSE_LIGHT = 41,      //light off
	PTZ_SCAN_REMOVE = 44,      //remove scan
	PTZ_REMOVE_AUTO_STUDY = 45,     //remove auto study
	PTZ_INFRARED_CTRL = 46,        //IR control
	PTZ_GET_PTZ_POSTION_REQ = 47,   //get PTZ position request
	PTZ_GET_PTZ_POSTION_RESP = 48,   //get PTZ position response
	PTZ_SET_PTZ_POSTION = 49,        //set PTZ position
	PTZ_SET_PTZ_NORTH_POSTION = 50,   //set north positio
	PTZ_GET_PRESET_REQ = 51,      //get preset request
	PTZ_GET_PRESET_RESP = 52,     //get preset response
	PTZ_GET_TOUR_REQ = 53,    //get tour request
	PTZ_GET_TOUR_RESP = 54,    //get tour response
	PTZ_GET_SCAN_REQ = 55,    //get scan request
	PTZ_GET_SCAN_RESP = 56,    //get scan response
	PTZ_GET_AUTO_STUDY_REQ = 57,    //get auto study request
	PTZ_GET_AUTO_STUDY_RESP = 58,    //get auto study response
	PTZ_GET_KEEPER_REQ = 59,     //get keeper request
	PTZ_GET_KEEPER_RESP = 60,    //get keeper response
	PTZ_INFRARED_STRL_V2 = 61,   //extended commands for IR light control
	PTZ_INFRARED_STRL_V2_REQ = 62,   //command to request infrared light control parameters
	PTZ_STOP_BRUSH = 63,       //stop brush
	PTZ_360_ROTATE_SCAN = 64,  //360 rotate scan
	PTZ_PERPENDICVULAR_SCAN = 65,  //perpendicvular scan
	PTZ_HEART_BEAT = 66,       //heart beat
	PTZ_INFRARED_CTRL_V2_RESP = 67, //response to command requesting IR control parameters
	PTZ_GET_ALARM_IO_START_REQ = 70,   //request to get status of alarm IO
	PTZ_GET_ALARM_IO_START_RESP = 71,  //response to status of alarm IO
	PTZ_PT_STOP_STATUS_RESP = 72,     //query of PT stop status
	PTZ_PT_POS_AUTO_RESP = 73,        //automatically report PT coordinates
	PTA_ALARM_IO_STATUS_AUTO_RESP = 74,   //automatically report IO alarm status
	PTZ_GET_ZOOM_VALUE = 75,       //zoom value
	PTZ_GET_PTZ_VERSION = 76,      //get PTZ version 
	PTZ_GET_MCU_TEMPERATURE = 77,   //get MCU temperature
	PTZ_LOAD_DEFAULT = 78,          //clear all operation
	PTZ_GET_PT_POSTION = 79,
	PTZ_SET_VERTICAL_MAX_POSTION = 80,
	PTZ_LENS_RESET = 81,	/*autofocus lens (including ABF) reset *//*BOOL*/
	PTZ_AUTO_TRACK = 82,
	PTZ_GET_PTZ_ACTION_STATUS_REQ = 83,	//request to get PTZ motion status
	PTZ_GET_PTZ_ACTION_STATUS_RESP = 84,	//response to PTZ motion status
	PTZ_SET_WIPER_MODE = 85,	//set brush mode
	PTZ_GET_WIPER_MODE = 86,	//get brush mode
	PTZ_SET_PTZ_POWER_SAVE = 87,	//set PTZ power save
	PTZ_GET_PTZ_POWER_SAVE = 88,	//get PTZ power save
	PTZ_SET_PT_LIMIT_POS = 89,	//set PT limit position
	PTZ_GET_PT_LIMIT_POS_REQ = 90,	//get PT limit position request
	PTZ_GET_PT_LIMIT_POS_RESP = 91,	//get PT limit position response
	PTZ_CLEAR_PT_LIMIT_POS = 92,	//clear PT limit position
	PTZ_SET_PT_SELFCHECK = 93,	//set PT selfcheck
	PTZ_GET_PT_SELFCHECK = 94,	//get PT selfcheck
	PTZ_SET_ORIENTATION = 95,	//set installation method
	PTZ_GET_ORIENTATION = 96,	//get installation method
	PTZ_SET_SHORTCUT = 97,	//set shortcut
	PTZ_GET_SHORTCUT = 98,	//get shortcut
	PTZ_SET_DN_MODE = 99,	//set D/N mode
	PTZ_SET_WHITE_LIGHT = 100,	//set status of white light
	PTZ_GET_WHITE_LIGHT = 101,	//get status of white light
	PTZ_GET_DN_MODE = 102,	//get D/N mode
	PTZ_SET_ZOOM_VALUE = 103,	//set zoom value
	PTZ_SET_FOCUS_VALUE = 104,	//set focus value
	PTZ_GET_FOCUS_VALUE = 105,	//get focus value
	PTZ_BOW_SCAN = 110,	//bow scan
	PTZ_BOW_SCAN_SET_STARTPOINT = 111,	//set startpoint of bow scan
	PTZ_BOW_SCAN_SET_STOPPOINT = 112,	//set endpoint of bow scan	
	PTZ_BOW_SCAN_REMOVE = 113,	//remove bow scan
	PTZ_BOW_SCAN_PAUSE = 114,	//pause bow scan
	PTZ_BOW_SCAN_CONTINUE = 115,	//continue bow scan
	PTZ_OPEN_DEFOG = 120,	//enable defog
	PTZ_CLOSE_DEFOG = 121,	//disable defog	
	PTZ_HOME = 133	//come back home
}ptz_operation_e;
enum SET_PTZ_POSION_TYPE
{
	POSTION_TYPE_PAN = 0x01, //pan
	POSTION_TYPE_TILE = 0x02, //tilt
	POSTION_TYPE_ZOOM = 0x04  //zoom
};
enum PTZ_DIRECTION
{
	EAST = 0x00,
	SOUTHEAST = 0x01,
	SOUTH = 0x02,
	SOUTHWEST = 0x03,
	WEST = 0x04,
	NORTHWEST = 0x05,
	NORTH = 0x06,
	NORTHEAST = 0x07
};
enum PTZ_RUN_KEEPER
{
	RUN_KEEPER_OFF = 0x00,	//keeper off
	RUN_KEEPER_ON = 0x02  //keeper on
};
enum PTZ_ZOOM
{
	ZOOM_SPEED_MIN = 0x00, //min value of the zoom in/zoom out speed values
	ZOOM_SPEED_MAX = 0x3F  //max value of the zoom in/zoom out speed values
};
enum PTZ_ROTATE_TYPE
{
	ROTATE_TYPE_GEAR = 0x00,	//gear1-64
	ROTATE_TYPE_SPEED = 0x01,	//speed
	ROTATE_TYPE_DEGREE = 0x02	//degree
};
enum
{
	CONFIGURE_PRESET = 0,
	CONFIGURE_SCAN = 1,
	CONFIGURE_TRACK = 2,
	CONFIGURE_TOUR = 3,
	CONFIGURE_KEEPER = 4,
	CONFIGURE_GET_SPEED = 6,
};

//time parameters
typedef struct  _dev_time_zone_param_t_
{
	int				nTimeZone;												//time zone

	unsigned char	bDSTOpenFlag;											//sign when DST switch on

	int				nBeginMonth;											//start month of DST
	int				nBeginWeekly;											//start week of DST (which week in the month)
	int				nBeginWeekDays;											//day of the week
	unsigned int	nBeginTime;												//begin time

	int				nEndMonth;												//end month of DST
	int				nEndWeekly;												//end week of DST (which week in the month)
	int				nEndWeekDays;											//day of the week
	unsigned int	nEndTime;												//end time

}dev_time_zone_param_t;

typedef struct _dev_modify_password_info_t_
{
	char dev_old_password[64];
	char dev_new_password[64];
}dev_modify_password_info_t;

typedef struct _dev_user_info_t_
{
	char dev_username[64];
	char dev_password[64];
}dev_user_info_t;




//scheduled time
typedef struct _schedule_time_
{
	int week_day;
	unsigned long start_time;
	unsigned long end_time;
}schedule_time;

typedef struct _schedule_time_list_
{
	int					schedule_time_count;
	schedule_time	    time_list[CONST_MAX_PERIOD_RECORD_TIME_NUM];
}schedule_time_list;

typedef struct _detection_area_
{
	int width_num;
	int high_num;
	char data[512];
}detection_area;

typedef struct _time_struct_
{
	int				time_zone;				//time zone
	unsigned short	day_light_saving_time;	//DST
	unsigned short	year;					//year
	unsigned short 	month;					//month[1,12]
	unsigned short 	day;					//day[1,31]
	unsigned short 	day_of_week;				//day of the week[0,6]
	unsigned short 	hour;					//hour[0,23]
	unsigned short 	minute;				//min[0,59]
	unsigned short 	second;				//sec[0,59]
	int 			milli_seconds;			//microseconds[0,1000000]
}time_struct;

//////////////////motion detection///////////////////////////////
typedef struct _alarm_source_param_
{
	int					 enable;
	int					 alarm_interval;
	int				     check_block_num;
	int					 sensitivity;
	int                  time_list_size;
	int					 area_datalen;
	detection_area		 area;
	schedule_time		 time_list[200];
}alarm_source_param;

//alarm action
typedef struct _alarm_action_
{
	int action_type;	//type of alarm source
	int action_id;		//ID of alarm source
	char action_name[MAX_DEV_NAME_LEN];		//name of alarm source
}alarm_action;

//PTZ alarm parameters
typedef struct _ptz_action_param_
{
	int ptz_action_type;	//type of action (preset, trace, etc.)
	int ptz_action_id;		//operation ID (preset ID, trace ID, etc. previously set by the user)
	int ptz_channel_id;		//PTZ channel ID 
	alarm_action  alarm_act;
}ptz_action_param;

//alarm out parameters
typedef struct _alarm_out_param_
{
	char dev_id[MAX_LENGTH_DEVICEID + 1];		//device ID
	int alarm_out_id;	//ID number of the alarm output port
	int alarm_out_flag;	//alarm out flag
	int event_type_id;	//type of alarm event
	int alarm_time;		//alarm out time
	alarm_action  alarm_act;
}alarm_out_param;

//linked recording parameters
typedef struct _record_act_param_
{
	unsigned char pre_record_flag; //whether to enable pre-recording
	int			delay_record_time;	//delay recording time
	alarm_action	alarm_act;
}record_act_param;


//linked alarm parameters
typedef struct _alarm_link_t_
{
	int			action_type;
	int			action_id;
}alarm_link;

typedef struct _mot_detect_param_
{
	alarm_source_param  objSourceParam;
	alarm_link          objLinkParamList[10];
	ptz_action_param    objPtzParamList[10];
	alarm_out_param		objAlarmOutList[10];
	record_act_param	objRecordActionList[10];
}mot_detect_param;

//parameters of IO alarm insource type
typedef struct _io_alarm_insource_para_
{
	alarm_action		alarm_act;
	unsigned char		enable_flag;	//enable flag
	int					alarm_inval;	//alarm interval
	int					valid_level;	//valid level
	schedule_time_list  schedule_para;
}io_alarm_insource_para;

typedef struct _io_alarm_event_para_
{
	io_alarm_insource_para   insource_para;
	int					linkage_param_count;
	alarm_link          link_param_list[CONST_MAX_ALARM_IO_NUM];
	int					ptz_action_action_param_list_count;
	ptz_action_param    ptz_param_list[CONST_MAX_ALARM_IO_NUM];
	int					alarm_out_count;
	alarm_out_param		alarm_out_list[CONST_MAX_ALARM_IO_NUM];
	int					record_action_param_list_count;
	record_act_param	record_action_list[CONST_MAX_ALARM_IO_NUM];
}io_alarm_event_para;

typedef struct _io_alarm_event_para_list_
{
	int		alarm_event_list_count;
	io_alarm_event_para alarm_event_list[CONST_MAX_ALARM_IO_NUM];
}io_alarm_event_para_list;

typedef struct _disk_alarm_source_para_
{
	alarm_action		alarm_act;
	unsigned short		enable_flag;	//whether to start the disk alarm (false: do not start, true: start)
	int		            alarm_inval;	//reporting interval, in seconds, the minimum interval is 10 seconds, and the maximum is 86400 seconds (1 day)
	int					alarm_thresold;//alarm threshold, in percent
	unsigned short		disk_full_enable_flag;
	unsigned short		disk_error_enable_flag;
	unsigned short		no_disk_enable_flag;
	schedule_time_list  schedule_para;
}disk_alarm_source_para;

//disk alarm parameters
typedef struct _disk_alarm_event_para_
{
	disk_alarm_source_para disk_alarm_source;
	int					linkage_param_count;
	alarm_link          link_param_list[CONST_MAX_ALARM_OUT_NUM];
	int					ptz_action_action_param_list_count;
	ptz_action_param    ptz_param_list[CONST_MAX_ALARM_OUT_NUM];
	int					alarm_out_count;
	alarm_out_param		alarm_out_list[CONST_MAX_ALARM_OUT_NUM];
	int					record_action_param_list_count;
	record_act_param	record_action_list[CONST_MAX_ALARM_OUT_NUM];
}disk_alarm_event_para;

typedef struct _disk_alarm_event_para_list_
{
	int					disk_alarm_event_count;
	disk_alarm_event_para disk_alarm_event_list[CONST_MAX_ALARM_OUT_NUM];
}disk_alarm_event_para_list;



//information of query condition
typedef struct _qry_info_
{
	char				dev_id[MAX_LENGTH_DEVICEID + 1];		//device ID
	long				channel_id;								//channel ID
	long				record_mode;							//query mode (recording query or snapshot query)
	long				select_mode;							//query mode (0: all; 1: query by type; 2: query by time)
	long				major_type;								//major type
	long				minor_type;								//minor type
	long				precision;								//precision
	int					record_segment_interval;		////query segment time length (max time span of each segment)
	time_struct			begin_time;						//begin time
	time_struct			end_time;						//end time

}qry_info;


typedef struct _qry_info_list_
{
	int				qry_info_count;
	qry_info		qry_info_list[CONST_MAX_ALARM_OUT_NUM];
}qry_info_para_list;

typedef struct  _alarm_info_qry_
{
	char			dev_ip[MAX_IP_BUF_LEN];					//device IP
	char			dev_id[MAX_LENGTH_DEVICEID + 1];
	int				source_id;	//alarm soour Id
	int				select_mode;	//select mode :SELECT_MODE_ALL
	char			source_name[MAX_DEV_NAME_LEN];	//source name
	int				major_type;	//alarm major type
	int				minor_type;	//alarm minor type
	unsigned long				alarm_begin_time;	//query start time
	time_struct				alarm_begin_time_struct;	//
	unsigned long				alarm_end_time;	//query end time
	time_struct				alarm_end_time_struct;	//
}alarm_info_qry;

//thermal temperature data and picture data
typedef struct tagThermalAVDataPic
{
	char				magic[4];				//magicagic number, default 0xffff ffff
	unsigned int		vesion;					//payload protocol version number, in network byte order
	unsigned int		head_len;				//header data length, in network byte order
	unsigned int		temper_payload_len;			//indicates the total size of temperature measurement data, in network byte order
	unsigned int		image_payload_len;		//indicates the total size of the image data, in network byte order
	unsigned int		width;					//temperature measurement matrix width, in network byte order (starting with specific header data)
	unsigned int		hight;					//temperature measurement matrix is high, in network byte order
	unsigned int		image_stride;			//span of the raw image (in bytes, imageStride/imageWidth=the number of bytes occupied by each pixel, the current raw image is valid for high 14bit), in network byte order
	unsigned int		temper_data_zoom_in;	//magnification of the temperature measurement data, and the obtained temperature is divided by this value to get the real temperature, such as 12345/100=123.45
	unsigned int		mirror_mode;			//mirror mode for raw images (:normal, :horizontal, :vertical, :horizontal-vertical), in network byte order
	unsigned int		capture_timeh;          //high-order timestamp of raw image, in network byte order
	unsigned int		capture_timel;          //low-order timestamp of raw image, in network byte order
	unsigned int		sequence_id;			//serial number of the raw image, incrementing each time, in network byte order
	unsigned int		image_type;				//0:JPG, in network byte order
	unsigned int		image_width;			//width of the image, in network byte order
	unsigned int		image_height;			//height of the image, in network byte order
	char				reserve[64];			//reserved field
}ST_ThermalAVDataPic;


#ifdef WIN32
typedef enum sdks_zoomin_graduate_e
{
	SDKS_ZOOMIN_GRADUATE_MIN = 0, ///<magnification
	SDKS_ZOOMIN_GRADUATE_1,       ///<magnification increase 0.25 
	SDKS_ZOOMIN_GRADUATE_2,       ///<magnification increase 0.5 
	SDKS_ZOOMIN_GRADUATE_3,       ///<magnification increase 0.75 
	SDKS_ZOOMIN_GRADUATE_4,       ///<magnification increase 1.0 
	SDKS_ZOOMIN_GRADUATE_5,       ///<magnification increase 1.25 
	SDKS_ZOOMIN_GRADUATE_6,       ///<magnification increase 1.5 
	SDKS_ZOOMIN_GRADUATE_7,       ///<magnification increase 1.75 
	SDKS_ZOOMIN_GRADUATE_8,       ///<magnification increase 2.0 
	SDKS_ZOOMIN_GRADUATE_9,       ///<magnification increase 2.25 
	SDKS_ZOOMIN_GRADUATE_10,      ///<magnification increase 2.5 
	SDKS_ZOOMIN_GRADUATE_11,      ///<magnification increase 2.75 
	SDKS_ZOOMIN_GRADUATE_12,      ///<magnification increase 3.0
	SDKS_ZOOMIN_GRADUATE_13,      ///<magnification increase 3.25 
	SDKS_ZOOMIN_GRADUATE_14,      ///<magnification increase 3.5 
	SDKS_ZOOMIN_GRADUATE_15,      ///<magnification increase 3.75 
	SDKS_ZOOMIN_GRADUATE_16,      ///<magnification increase 4.0 
	SDKS_ZOOMIN_GRADUATE_17,      ///<magnification increase 4.25 
	SDKS_ZOOMIN_GRADUATE_18,      ///<magnification increase 4.5 
	SDKS_ZOOMIN_GRADUATE_19,      ///<magnification increase 4.75
	SDKS_ZOOMIN_GRADUATE_20,	  ///<magnification increase 5.0 
	SDKS_ZOOMIN_GRADUATE_21,	  ///<magnification increase 5.25
	SDKS_ZOOMIN_GRADUATE_22,	  ///<magnification increase 5.5 
	SDKS_ZOOMIN_GRADUATE_23,	  ///<magnification increase 5.75
	SDKS_ZOOMIN_GRADUATE_24,	  ///<magnification increase 6.0 
	SDKS_ZOOMIN_GRADUATE_25,	  ///<magnification increase 6.25
	SDKS_ZOOMIN_GRADUATE_26,	  ///<magnification increase 6.5 
	SDKS_ZOOMIN_GRADUATE_27,	  ///<magnification increase 6.75
	SDKS_ZOOMIN_GRADUATE_28,	  ///<magnification increase 7.0 
	SDKS_ZOOMIN_GRADUATE_29,	  ///<magnification increase 7.25
	SDKS_ZOOMIN_GRADUATE_30,	  ///<magnification increase 7.5 
	SDKS_ZOOMIN_GRADUATE_31,	  ///<magnification increase 7.75
	SDKS_ZOOMIN_GRADUATE_32,	  ///<magnification increase 8.0 
	SDKS_ZOOMIN_GRADUATE_33,	  ///<magnification increase 8.25
	SDKS_ZOOMIN_GRADUATE_34,	  ///<magnification increase 8.5 
	SDKS_ZOOMIN_GRADUATE_35,	  ///<magnification increase 8.75
	SDKS_ZOOMIN_GRADUATE_36,	  ///<magnification increase 9.0 
	SDKS_ZOOMIN_GRADUATE_37,	  ///<magnification increase 9.25
	SDKS_ZOOMIN_GRADUATE_38,	  ///<magnification increase 9.5 
	SDKS_ZOOMIN_GRADUATE_39,	  ///<magnification increase 9.75
	SDKS_ZOOMIN_GRADUATE_40,	  ///<magnification increase 10.0 
	SDKS_ZOOMIN_GRADUATE_41,	  ///<magnification increase 10.25
	SDKS_ZOOMIN_GRADUATE_42,	  ///<magnification increase 10.5 
	SDKS_ZOOMIN_GRADUATE_43,	  ///<magnification increase 10.75
	SDKS_ZOOMIN_GRADUATE_44,	  ///<magnification increase 11.0 
	SDKS_ZOOMIN_GRADUATE_45,	  ///<magnification increase 11.25
	SDKS_ZOOMIN_GRADUATE_46,	  ///<magnification increase 11.5 
	SDKS_ZOOMIN_GRADUATE_47,	  ///<magnification increase 11.75
	SDKS_ZOOMIN_GRADUATE_48,	  ///<magnification increase 12.0 
	SDKS_ZOOMIN_GRADUATE_49,	  ///<magnification increase 12.25
	SDKS_ZOOMIN_GRADUATE_50,	  ///<magnification increase 12.5 
	SDKS_ZOOMIN_GRADUATE_51,	  ///<magnification increase 12.75
	SDKS_ZOOMIN_GRADUATE_52,	  ///<magnification increase 13.0 
	SDKS_ZOOMIN_GRADUATE_53,	  ///<magnification increase 13.25
	SDKS_ZOOMIN_GRADUATE_54,	  ///<magnification increase 13.5 
	SDKS_ZOOMIN_GRADUATE_55,	  ///<magnification increase 13.75
	SDKS_ZOOMIN_GRADUATE_56,	  ///<magnification increase 14.0 
	SDKS_ZOOMIN_GRADUATE_57,	  ///<magnification increase 14.25
	SDKS_ZOOMIN_GRADUATE_58,	  ///<magnification increase 14.5 
	SDKS_ZOOMIN_GRADUATE_59,	  ///<magnification increase 14.75
	SDKS_ZOOMIN_GRADUATE_60,	  ///<magnification increase 15.0 
	SDKS_ZOOMIN_GRADUATE_MAX
}sdks_zoomin_graduate_e;

#endif

#endif
